Attribute VB_Name = "SamplePrint"
Option Explicit

'*************************************************************
' WIN32֘A
'*************************************************************

' ******************************************************
' APIp
' ******************************************************
Type DOCINFO
        cbSize As Long
        lpszDocName As String
        lpszOutput As String
End Type

Declare Function StartDoc Lib "gdi32" Alias "StartDocA" ( _
    ByVal hdc As Long, _
    lpdi As DOCINFO _
) As Long
Declare Function StartPage Lib "gdi32" (ByVal hdc As Long) As Long
Declare Function EndPage Lib "gdi32" (ByVal hdc As Long) As Long
Declare Function EndDoc Lib "gdi32" (ByVal hdc As Long) As Long
Declare Function AbortDoc Lib "gdi32" (ByVal hdc As Long) As Long

' ******************************************************
' f[^o͗p
' ******************************************************
Declare Function TextOut Lib "gdi32" Alias "TextOutA" ( _
    ByVal hdc As Long, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal lpString As String, _
    ByVal nCount As Long _
) As Long
Public Const DT_TOP = &H0
Public Const DT_LEFT = &H0
Public Const DT_CENTER = &H1
Public Const DT_RIGHT = &H2
Public Const DT_VCENTER = &H4
Public Const DT_BOTTOM = &H8
Public Const DT_WORDBREAK = &H10
Public Const DT_SINGLELINE = &H20
Public Const DT_EXPANDTABS = &H40
Public Const DT_TABSTOP = &H80
Public Const DT_NOCLIP = &H100
Public Const DT_EXTERNALLEADING = &H200
Public Const DT_CALCRECT = &H400
Public Const DT_NOPREFIX = &H800
Public Const DT_INTERNAL = &H1000
Declare Function DrawText Lib "user32" Alias "DrawTextA" ( _
    ByVal hdc As Long, _
    ByVal lpStr As String, _
    ByVal nCount As Long, _
    lpRect As RECT, _
    ByVal wFormat As Long _
) As Long

' ******************************************************
' p
' ******************************************************
Type POINTAPI
        x As Long
        y As Long
End Type

'Declare Function MoveToEx Lib "gdi32" ( _
'    ByVal hDc As Long, _
'    ByVal x As Long, _
'    ByVal y As Long, _
'    lpPoint As POINTAPI _
') As Long
Declare Function MoveToEx Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal pLastPoint As Long _
) As Long

Declare Function LineTo Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal x As Long, _
    ByVal y As Long _
) As Long

' ******************************************************
' Fhp
' ******************************************************
Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type
Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Declare Function SelectObject Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal hObject As Long _
) As Long
Declare Function FillRect Lib "user32" ( _
    ByVal hdc As Long, _
    lpRect As RECT, _
    ByVal hBrush As Long _
) As Long
Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long


' ******************************************************
' foCX擾
' ******************************************************
Declare Function GetDeviceCaps Lib "gdi32" ( _
    ByVal hdc As Long, _
    ByVal nIndex As Long _
) As Long

Public Const PHYSICALWIDTH = 110 '  Physical Width in device units
Public Const PHYSICALHEIGHT = 111 '  Physical Height in device units
Public Const PHYSICALOFFSETX = 112 '  Physical Printable Area x margin
Public Const PHYSICALOFFSETY = 113 '  Physical Printable Area y margin
Public Const SCALINGFACTORX = 114 '  Scaling factor x
Public Const SCALINGFACTORY = 115 '  Scaling factor y

Type TEXTMETRIC
        tmHeight As Long
        tmAscent As Long
        tmDescent As Long
        tmInternalLeading As Long
        tmExternalLeading As Long
        tmAveCharWidth As Long
        tmMaxCharWidth As Long
        tmWeight As Long
        tmOverhang As Long
        tmDigitizedAspectX As Long
        tmDigitizedAspectY As Long
        tmFirstChar As Byte
        tmLastChar As Byte
        tmDefaultChar As Byte
        tmBreakChar As Byte
        tmItalic As Byte
        tmUnderlined As Byte
        tmStruckOut As Byte
        tmPitchAndFamily As Byte
        tmCharSet As Byte
End Type
Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" ( _
    ByVal hdc As Long, _
    lpMetrics As TEXTMETRIC _
) As Long

' ******************************************************
' tHg
' ******************************************************
'used with fnWeight
Const FW_DONTCARE = 0
Const FW_THIN = 100
Const FW_EXTRALIGHT = 200
Const FW_LIGHT = 300
Const FW_NORMAL = 400
Const FW_MEDIUM = 500
Const FW_SEMIBOLD = 600
Const FW_BOLD = 700
Const FW_EXTRABOLD = 800
Const FW_HEAVY = 900
Const FW_BLACK = FW_HEAVY
Const FW_DEMIBOLD = FW_SEMIBOLD
Const FW_REGULAR = FW_NORMAL
Const FW_ULTRABOLD = FW_EXTRABOLD
Const FW_ULTRALIGHT = FW_EXTRALIGHT

'used with fdwCharSet
Const ANSI_CHARSET = 0
Const DEFAULT_CHARSET = 1
Const SYMBOL_CHARSET = 2
Const SHIFTJIS_CHARSET = 128
Const HANGEUL_CHARSET = 129
Const CHINESEBIG5_CHARSET = 136
Const OEM_CHARSET = 255

'used with fdwOutputPrecision
Const OUT_CHARACTER_PRECIS = 2
Const OUT_DEFAULT_PRECIS = 0
Const OUT_DEVICE_PRECIS = 5
'used with fdwClipPrecision
Const CLIP_DEFAULT_PRECIS = 0
Const CLIP_CHARACTER_PRECIS = 1
Const CLIP_STROKE_PRECIS = 2
'used with fdwQuality
Const DEFAULT_QUALITY = 0
Const DRAFT_QUALITY = 1
Const PROOF_QUALITY = 2

' Pitch and family constants.
Public Const DEFAULT_PITCH = 0
Public Const FIXED_PITCH = 1
Public Const VARIABLE_PITCH = 2
Public Const TRUETYPE_FONTTYPE = &H4
Public Const FF_DECORATIVE = 80 '  Old English, etc.
Public Const FF_DONTCARE = 0    '  Don't care or don't know.
Public Const FF_MODERN = 48     '  Constant stroke width, serifed or sans-serifed.
Public Const FF_ROMAN = 16      '  Variable stroke width, serifed.
Public Const FF_SCRIPT = 64     '  Cursive, etc.
Public Const FF_SWISS = 32      '  Variable stroke width, sans-serifed.

'used with SetBkMode
Const OPAQUE = 2
Const TRANSPARENT = 1

Declare Function CreateFont Lib "gdi32" Alias "CreateFontA" ( _
    ByVal H As Long, _
    ByVal W As Long, _
    ByVal E As Long, _
    ByVal O As Long, _
    ByVal W As Long, _
    ByVal i As Long, _
    ByVal u As Long, _
    ByVal S As Long, _
    ByVal C As Long, _
    ByVal OP As Long, _
    ByVal CP As Long, _
    ByVal Q As Long, _
    ByVal PAF As Long, _
    ByVal F As String _
) As Long
Public Const LOGPIXELSX = 88        '  Logical pixels/inch in X
Public Const LOGPIXELSY = 90        '  Logical pixels/inch in Y
Declare Function MulDiv Lib "kernel32" ( _
    ByVal nNumber As Long, _
    ByVal nNumerator As Long, _
    ByVal nDenominator As Long _
) As Long

' ******************************************************
' y
' ******************************************************
'fnPenStyle̒萔
Private Const PS_SOLID = 0              '
Private Const PS_DASH = 1               'j
Private Const PS_DOT = 2                '_
Private Const PS_DASHDOT = 3            '_
Private Const PS_DASHDOTDOT = 4         '_
Private Const PS_NULL = 5               '\
Private Const PS_INSIDEFRAME = 6        'hԂ

Declare Function CreatePen Lib "gdi32.dll" _
    (ByVal fnPenStyle As Long, ByVal nWidth As Long, _
     ByVal crColor As Long) As Long

'*************************************************************
' 萔`
'*************************************************************

'*************************************************************
' ϐ`
'*************************************************************

'*************************************************************
' Tv
'*************************************************************
Sub PROC_SamplePrint(hdc As Long, strText As String)

    Dim hFontOld As Long
    Dim hDate As Long
    Dim hTitle As Long
    Dim hGreeting As Long
    Dim hText As Long
    Dim hPenTitle As Long
    Dim hPenText As Long
    Dim hOldPen As Long

    Dim rectDate As RECT
    Dim rectTitle As RECT
    Dim rectGreeting As RECT
    Dim rectText As RECT

    Dim strDate As String

    Dim di As DOCINFO

    hDate = 0
    hTitle = 0
    hGreeting = 0
    hText = 0

    di.cbSize = 12
    di.lpszDocName = "PrtCli2"
    
    If StartDoc(hdc, di) <= 0 Then
        Exit Sub
    End If
    
    If StartPage(hdc) <= 0 Then
        AbortDoc (hdc)
        Exit Sub
    End If
    
    '-------------------------------------------------------------
    ' tHg쐬
    hDate = CreateFont(-24, 0, 0, 0, FW_SEMIBOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
    hTitle = CreateFont(-72, 0, 0, 0, FW_BOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
    hGreeting = CreateFont(-48, 0, 0, 0, FW_SEMIBOLD, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")
    hText = CreateFont(-36, 0, 0, 0, FW_DONTCARE, False, False, False, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH Or FF_ROMAN, "lr SVbN")

    '-------------------------------------------------------------
    ' y쐬
    hPenTitle = CreatePen(PS_SOLID, 8, RGB(0, 0, 0))
    hPenText = CreatePen(PS_SOLID, 4, RGB(0, 0, 0))

    '-------------------------------------------------------------
    ' Wݒ
    rectDate.Top = 50
    rectDate.Bottom = 80
    rectDate.Left = 1010
    rectDate.Right = 1510
    rectTitle.Top = 90
    rectTitle.Bottom = 190
    rectTitle.Left = 10
    rectTitle.Right = 1510
    rectGreeting.Top = 200
    rectGreeting.Bottom = 400
    rectGreeting.Left = 20
    rectGreeting.Right = 1500
    rectText.Top = 410
    rectText.Bottom = 1210
    rectText.Left = 30
    rectText.Right = 1490

    '-------------------------------------------------------------
    ' t
    strDate = Format$(Now, "yyyy") + "N" + Format$(Now, "mm") + "" + Format$(Now, "dd") + ""
    hFontOld = SelectObject(hdc, hDate)
    Call DrawText(hdc, strDate, LenB(StrConv(strDate, vbFromUnicode)), rectDate, DT_NOPREFIX Or DT_WORDBREAK Or DT_RIGHT Or DT_SINGLELINE)

    '-------------------------------------------------------------
    ' ^Cg
           
    Call SelectObject(hdc, hTitle)
    Call DrawText(hdc, "e`we", LenB(StrConv("e`we", vbFromUnicode)), rectTitle, DT_NOPREFIX Or DT_WORDBREAK Or DT_CENTER Or DT_VCENTER Or DT_SINGLELINE)

    hOldPen = SelectObject(hdc, hPenTitle)
    Call MoveToEx(hdc, rectTitle.Left, rectTitle.Top, 0)
    Call LineTo(hdc, rectTitle.Right, rectTitle.Top)
    Call MoveToEx(hdc, rectTitle.Left, rectTitle.Bottom, 0)
    Call LineTo(hdc, rectTitle.Right, rectTitle.Bottom)

    '-------------------------------------------------------------
    ' A
    Call SelectObject(hdc, hGreeting)
    Call DrawText(hdc, "STARFAXAɂ肪Ƃ܂B", LenB(StrConv("STARFAXAɂ肪Ƃ܂B", vbFromUnicode)), rectGreeting, DT_NOPREFIX Or DT_WORDBREAK Or DT_CENTER Or DT_VCENTER Or DT_SINGLELINE)

    '-------------------------------------------------------------
    ' {
    Call SelectObject(hdc, hPenText)
    Call MoveToEx(hdc, rectText.Left, rectText.Top, 0)
    Call LineTo(hdc, rectText.Right, rectText.Top)
    Call LineTo(hdc, rectText.Right, rectText.Bottom)
    Call LineTo(hdc, rectText.Left, rectText.Bottom)
    Call LineTo(hdc, rectText.Left, rectText.Top)
    rectText.Top = rectText.Top + 20
    rectText.Bottom = rectText.Bottom - 20
    rectText.Left = rectText.Left + 20
    rectText.Right = rectText.Right - 20
    Call SelectObject(hdc, hText)
    Call DrawText(hdc, strText, LenB(StrConv(strText, vbFromUnicode)), rectText, DT_NOPREFIX Or DT_WORDBREAK)

    Call SelectObject(hdc, hFontOld)
    DeleteObject (hDate)
    DeleteObject (hTitle)
    DeleteObject (hGreeting)
    DeleteObject (hText)

    Call SelectObject(hdc, hOldPen)
    DeleteObject (hPenTitle)
    DeleteObject (hPenText)

    EndPage (hdc)
    EndDoc (hdc)

End Sub

